/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IOs {
    public static final long _1_Ko = 1024L;
    public static final long _8_Ko = 8192L;
    public static final long _512_Ko = 524288L;
    public static final long _1_Mo = 0x100000L;
    public static final long _1_Go = 0x40000000L;

    public static ByteArrayInputStream toByteArrayInputStream(InputStream inputStream) throws IOException {
        return IOs.toByteArrayInputStream(inputStream, 1024);
    }

    public static ByteArrayInputStream toByteArrayInputStream(InputStream inputStream, int bufferSize) throws IOException {
        return new ByteArrayInputStream(IOs.toByteArray(inputStream, bufferSize));
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOs.toByteArray(inputStream, 1024);
    }

    public static byte[] toByteArray(InputStream inputStream, int bufferSize) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            IOs.copy(inputStream, bos, bufferSize);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int b;
        byte[] readBytes = new byte[bufferSize];
        while ((b = inputStream.read(readBytes)) != -1) {
            outputStream.write(readBytes, 0, b);
        }
    }

    private IOs() {
    }

    public static class InputStreamIterator
    implements Iterator<byte[]> {
        private final InputStream source;
        private final int packetSize;
        private final byte[] buffer;

        public static Iterable<byte[]> iterable(InputStream source, int packetSize) {
            return () -> new InputStreamIterator(source, packetSize);
        }

        public InputStreamIterator(InputStream source, int packetSize) {
            this.source = source;
            this.packetSize = packetSize;
            this.buffer = new byte[packetSize];
        }

        @Override
        public boolean hasNext() {
            try {
                return this.source.available() != 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int readBytesCount = this.source.read(this.buffer, 0, this.packetSize);
                if (readBytesCount == this.buffer.length) {
                    return this.buffer;
                }
                return Arrays.copyOf(this.buffer, readBytesCount);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

